*Title: Budget Tracking
*Slug: budget-tracking

================================================================

activeCollab enables you to set a <{term}>Project Budget<{/term}> for every Project. The budget will be influenced by logged expenses and billable hours.

<{note title="Hourly Rates"}>Hourly Rates can be set on the <{term}>Project Overview<{/term}> page. Use the <{option}>Hourly Rates<{/option}> option to add a new <{term}>Job Type<{/term}> and set the corresponding hourly rate. This rate can be set per Project or it can be made available across all your Projects by clicking <{option}>Job Type and Hourly Rate<{/option}> settings available in the Administration.<{/note}>

<{sub}>Setting a Project Budget<{/sub}>

A Project Budget can be set when creating a <{option}>New Project<{/option}> or updated at any point by clicking <{option}>Options > Edit<{/option}> on the <{term}>Project Overview<{/term}> page. As your Project is progressing, activeCollab will display the percentage that has been spent. When approaching the budget limit, the numbers will first become orange and finally turn red if the Project is over budget:

<{image name="budget_overload_zoom.png"}>

<{note title="Who Can See the Project Budget"}>Only <{term}>Administrators<{/term}> and <{term}>Managers<{/term}> with the **Manage Projects** permission enabled will be able to see the amount set as Project Budget by default on all the Projects in your activeCollab. 

To allow users with the <{term}>Member/Employee<{/term}> role to see the budget for the Project that they are working, enable the **See Project Budget** permission in their System Role settings.<{/note}>

<{sub}>Budget Report<{/sub}>

To see how well your budget stands against Estimated and Tracked Time or logged Expenses, go to the <{term}>Project Overview<{/term}> page and click <{option}>Options > Budget Report<{/option}>. 

<{image name="Project_budget.png"}>

This report will display the tracked time and expenses in relation to the available funds. Since activeCollab knows the hourly rate for every job type, it can calculate how much has already been spent, based on the logged time and expenses.

<{sub}>Budget Report Across all Projects<{/sub}>

If you wish to see a report that will let you know **how all your Projects are progressing and how much has been spent,** use the<{option}>Budget vs. Costs<{/option}> report available in <{option}>Reports & Filters<{/option}>. The report displays the Project Budget, Costs and the Budget Status (either as OK or Over Budget).

<{note title="Who Can Use Budget Reports"}>Budget reports can be used only by <{term}>Administrators<{/term}> and <{term}>Managers<{/term}> with the **Manage Projects** permission enabled for their System Role.<{/note}>